/**
* \file: trace_ald_interface.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Defines data srtuctures and declares functions for supporting Authorization Level in TRACE.
* *
* \component: Trace
*
* \author: Bewoayia Kebianyor
*
* \copyright (c) 2012, 2013 Advanced Driver Information Technology.

* This code is developed by Advanced Driver Information Technology.

* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.

* All rights reserved.
*
* \history
* 0.1 Bewoayia Kebianyor Initial version
*
***********************************************************************/
#include <stdlib.h>
#include	<search.h>
#include <stdio.h>

#include <sys/poll.h>
#include <stdbool.h>
#include <errno.h>
#include <string.h>
#include <signal.h>
#include <sys/epoll.h> /* For ePoll */


#define TRACE_ALD_NUM_SECURITY_LEVELS              4
#define TRACE_ALD_CUSTOMER_LEVEL_POS               0
#define TRACE_ALD_RESIDENT_LEVEL_POS               1
#define TRACE_ALD_SERVICE_LEVEL_POS                2
#define TRACE_ALD_PRODUCTION_LEVEL_POS             3
#define TRACE_ALD_MAXFILTERS		           100
#define TRACE_ALD_MAXFILTERSIZE	                   1024
#define TRACE_ALD_MAX_SUPPORTED_CALLBACK_CHANNELS  512
#define TRACE_ALD_MAX_TRACE_COMMMAND_TYPES          3      

// Define stated for the TRACE ALD Interface
#define TRACE_ALD_INTERFACE_NOT_INITIALISED  0
#define TRACE_ALD_INTERFACE_INITIALISED  1
#define TRACE_ALD_MAX_EPOLL_EVENTS   2

typedef struct{
    int trace_level;                        // Log level enabled for a TRACE application's class.
    int classID;                            // TRACE application's class.                     
}TRACE_ALD_ClassConfig;


typedef struct{
    int cmdType;                            // TRACE application's command Type.
    int *subCmdList;   
    TRACE_ALD_ClassConfig *classCmdConfig;  // Application Specific configuration for configuring trace levels for applications trace classes.                  
    int num_sub_cmds;                  // Number of configured Trace Commands. 
    int num_class_config;              // Number of configured Trace Commands. 
}TRACE_ALD_CmdTypeConfig;


typedef struct{
    int security_level;                                            // Security Level for which the configuration is considered.
    TRACE_ALD_CmdTypeConfig traceCmdConfig[TRACE_ALD_MAX_TRACE_COMMMAND_TYPES];
}TRACE_ALD_LevelConfig;


typedef struct{ 
    int file_desc;
    unsigned int default_security_level;
    unsigned int system_security_level;
    unsigned int ald_customer_level;
    unsigned int ald_resident_level;
    unsigned int ald_service_level;
    unsigned int ald_production_level;
    unsigned int numTotalBEConfig;
    int epollHandle;  
    struct epoll_event eventHandle; /* Epoll event structure Handle */
    struct epoll_event events[TRACE_ALD_MAX_EPOLL_EVENTS]; /* Array of Epoll event struct handle */
    char  list[TRACE_ALD_MAXFILTERS][TRACE_ALD_MAXFILTERSIZE];
    char  keybuf[TRACE_ALD_MAXFILTERS][TRACE_ALD_MAXFILTERSIZE];
    TRACE_ALD_LevelConfig aldConfigTable[TRACE_ALD_NUM_SECURITY_LEVELS];
}TRACE_ALD_Mgr;


int TRACE_ald_interface_init(TRACE_ALD_Mgr *mgr);


int dlt_plugin_deinit_ald_plugin(void * trace_mgr,TRACE_ALD_Mgr *mgr);

int TRACE_ALD_interface_init_ald_plugin(TRACE_ALD_Mgr *mgr);

int TRACE_ALD_interface_deinit_ald_plugin(void * trace_mgr,TRACE_ALD_Mgr *ald_mgr);

/**
* Initialise epoll Handle to  and add filedescriptors
*
* \param  mgr  Pointer to Trace manager
*
* \return E_OK if successful
*              else error returned by concrete implementation
*/
IMPORT ER TRACE_ALD_interface_init_epoll_handle(TRACE_ALD_Mgr *ald_mgr);

/**
* Un Initialise epoll Handle to  and add filedescriptors
*
* \param  mgr  Pointer to Trace manager
*
* \return E_OK if successful
*              else error returned by concrete implementation
*/
IMPORT ER TRACE_ALD_interface_deinit_epoll_handle(TRACE_ALD_Mgr *ald_mgr);

IMPORT ER TRACE_ALD_interface_handle_ald_event(void *mgr,TRACE_ALD_Mgr *ald_mgr, bool ald_connected);

IMPORT bool TRACE_ALD_interface_is_command_supported(void *mgr);

